package ru.yandex.partner.jsonapi.utils.function;

import java.util.HashMap;
import java.util.List;

import javax.annotation.Nonnull;

import org.junit.jupiter.api.Test;

import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.DefectInfo;
import ru.yandex.direct.validation.result.Path;
import ru.yandex.direct.validation.result.PathHelper;
import ru.yandex.partner.core.validation.defects.ids.TypeDefectIds;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertThrows;

class OnePriorityBatchBiFunctionTest {

    @Test
    void acceptListWrongSize() {
        var onePriorityBatchBiFunction = new OnePriorityBatchBiFunction<Integer, Integer>() {
            @Override
            public List<DefectInfo<Defect<?>>> acceptOne(@Nonnull Integer var1, @Nonnull Integer var2) {
                return null;
            }
        };

        assertThrows(IndexOutOfBoundsException.class,
                () -> onePriorityBatchBiFunction.acceptList(List.of(1, 2), List.of(1)));
    }

    @Test
    void acceptList() {
        Path emptyPath = PathHelper.emptyPath();
        Defect<?> defect = new Defect<>(TypeDefectIds.INVALID_TYPE);
        var onePriorityBatchBiFunction = new OnePriorityBatchBiFunction<Integer, Integer>() {
            @Override
            public List<DefectInfo<Defect<?>>> acceptOne(@Nonnull Integer var1, @Nonnull Integer var2) {
                return List.of(new DefectInfo<>(emptyPath, var2, defect));
            }
        };

        var values = List.of(4, 6, 1, 8, 9);
        var resultMap = onePriorityBatchBiFunction.acceptList(List.of(1, 2, 3, 5, 8), values);

        var expectedMap = new HashMap<Integer, List<DefectInfo<Defect<?>>>>(values.size());
        for (int i = 0; i < values.size(); i++) {
            expectedMap.put(i, List.of(new DefectInfo<>(emptyPath, values.get(i), defect)));

        }

        if (!expectedMap.equals(resultMap)) {
            assertEquals(expectedMap, resultMap);
        }
    }
}
