package ru.yandex.partner.jsonapi.utils.function;

import java.util.List;

import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.assertEquals;

class OnePriorityBatchFunctionTest {

    @Test
    void applyList() {
        var onePriorityBatchFunction = new OnePriorityBatchFunction<Integer, Integer>() {
            @Override
            public Integer applyOne(Integer integer) {
                return integer * 2;
            }
        };

        var result = onePriorityBatchFunction.applyList(List.of(3, 6, 15, 543));

        assertEquals(
                List.of(6, 12, 30, 1086),
                result
        );
    }
}
