package ru.yandex.partner.jsonapi.validation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.partner.core.entity.block.container.BlockContainerImpl;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.block.repository.BlockTypedRepository;
import ru.yandex.partner.core.entity.block.service.OperationMode;
import ru.yandex.partner.core.entity.block.service.validation.type.BlockValidationTypeSupportFacade;

public abstract class AbstractBlockValidationTest<M extends BaseBlock> extends AbstractValidationTest<BaseBlock, M> {
    private static Map<String, String> modelPropertyStringMap = new HashMap<>();

    @Autowired
    BlockValidationTypeSupportFacade validationTypeSupportFacade;

    @Autowired
    BlockTypedRepository blockTypedRepository;

    @Override
    public Map<String, String> getModelPropertyStringMap() {
        return modelPropertyStringMap;
    }

    @Override
    public Class<BaseBlock> getBaseClass() {
        return BaseBlock.class;
    }

    @Override
    public BaseBlock getModelFromDb(Long id) {
        return blockTypedRepository.getBlockByCompositeId(id);
    }

    @Override
    public ValidationResult<List<BaseBlock>, Defect> validateModel(
            BaseBlock model, List<ModelChanges<BaseBlock>> modelChangesList) {
        BlockContainerImpl blockContainer = BlockContainerImpl.create(OperationMode.CRON);

        // Хранилище результата валидации
        ValidationResult<List<ModelChanges<BaseBlock>>, Defect> vr = new ValidationResult<>(modelChangesList);
        // Получаем обновлённые ModelChanges после применения дефолтов для optional полей
        ModelChanges<BaseBlock> modelChangesWithDefaults = vr.getValue().get(0);

        // Применяем ModelChanges к модели и получаем AppliedChanges
        AppliedChanges<BaseBlock> appliedChanges = modelChangesWithDefaults.applyTo(model);
        ValidationResult<List<BaseBlock>, Defect> modelsListValidationResult =
                new ValidationResult<>(List.of(appliedChanges.getModel()));

        // Вызываем основную валидацию сущности
        validationTypeSupportFacade.validate(blockContainer, modelsListValidationResult);

        return modelsListValidationResult;
    }
}
