package ru.yandex.partner.jsonapi.validation;

import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.JsonNode;

import ru.yandex.partner.test.utils.TestUtils;

public class ValidationTestEntity {
    private String model;
    private String name;
    private Boolean skip = false;
    private Map<String, JsonNode> options;
    private Map<String, JsonNode> patch;
    private ValidationTestPk pk;
    private ValidationTestResults result;

    public String getModel() {
        return model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getSkip() {
        return skip;
    }

    public void setSkip(Boolean skip) {
        this.skip = skip;
    }

    public Map<String, JsonNode> getOptions() {
        return options;
    }

    public <T> T getOption(String name, Class<T> tClass) {
        return TestUtils.parseOption(options, name, tClass);
    }

    public void setOptions(Map<String, JsonNode> options) {
        this.options = options;
    }

    public Map<String, JsonNode> getPatch() {
        return patch;
    }

    public void setPatch(Map<String, JsonNode> patch) {
        this.patch = patch;
    }

    public ValidationTestPk getPk() {
        return pk;
    }

    public void setPk(ValidationTestPk pk) {
        this.pk = pk;
    }

    public ValidationTestResults getResult() {
        return result;
    }

    public void setResult(ValidationTestResults result) {
        this.result = result;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", ValidationTestEntity.class.getSimpleName() + "[", "]")
                .add("model='" + model + "'")
                .add("name='" + name + "'")
                .add("options='" + options + "'")
                .add("patch=" + patch)
                .add("pk=" + pk)
                .add("result=" + result)
                .toString();
    }
}
