package ru.yandex.partner.jsonapi.validation;

import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

import org.jetbrains.annotations.NotNull;

public class ValidationTestResult implements Comparable<ValidationTestResult> {
    private List<String> path;
    private List<String> msgs;

    public ValidationTestResult() {
    }

    public ValidationTestResult(List<String> path, List<String> msgs) {
        this.msgs = msgs;
        this.path = path;
    }

    public List<String> getMsgs() {
        return msgs;
    }

    public void setMsgs(List<String> msgs) {
        this.msgs = msgs;
    }

    public List<String> getPath() {
        return path;
    }

    public void setPath(List<String> path) {
        this.path = path;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ValidationTestResult that = (ValidationTestResult) o;
        return Objects.equals(path, that.path) && Objects.equals(msgs, that.msgs);
    }

    @Override
    public int hashCode() {
        return Objects.hash(path, msgs);
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", ValidationTestResult.class.getSimpleName() + "[", "]")
                .add("path=" + path)
                .add("msgs=" + msgs)
                .toString();
    }

    @Override
    public int compareTo(@NotNull ValidationTestResult o) {
        return String.join("/", this.getPath()).compareTo(String.join("/", o.getPath()));
    }
}
