#!/bin/bash -e

APP_ROOT=${1:-/app/java/logbrokerapi}

/usr/bin/java -cp "$APP_ROOT/lib/*:" \
    -Djava.library.path="$APP_ROOT/lib/" \
    -Dspring.profiles.active="$LOGBROKERAPI_PROFILE" \
    -Dserver.port="${LOGBROKERAPI_SERVER_PORT}" \
    -Dmanagement.server.port="${LOGBROKERAPI_MANAGEMENT_PORT:-9090}" \
    -Dspring.pid.file="${LOGBROKERAPI_PID_FILE:-logbrokerapi.pid}" \
    ${JAVA_OPTS} \
    -Xmx"${LOGBROKER_MAX_MEMORY_G:-1}"g \
    ru.yandex.partner.logbrokerapi.LogbrokerApplication
