package ru.yandex.partner.logbrokerapi;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

import ru.yandex.partner.logbrokerapi.entity.JsonLogbrokerDto;
import ru.yandex.partner.unifiedagent.UnifiedAgentResult;
import ru.yandex.partner.unifiedagent.UnifiedAgentService;

@RestController
public class LogbrokerController {

    private final UnifiedAgentService unifiedAgentService;

    @Autowired
    public LogbrokerController(UnifiedAgentService unifiedAgentService) {
        this.unifiedAgentService = unifiedAgentService;
    }

    @PostMapping("/logbroker")
    public String add(@RequestBody JsonLogbrokerDto jsonLogbrokerDto) {
        UnifiedAgentResult result = unifiedAgentService.sendToLogbroker(jsonLogbrokerDto);
        if (UnifiedAgentResult.Status.VALIDATION_ERROR.equals(result.getStatus())) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, result.getDetails());
        }

        return "OK";
    }
}
