package ru.yandex.partner.logbrokerapi.entity;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.protobuf.ByteString;

import ru.yandex.partner.unifiedagent.LogbrokerDto;

public class JsonLogbrokerDto implements LogbrokerDto {
    private final String destination;
    private final String topic;
    private final List<String> messages;

    @JsonCreator
    public JsonLogbrokerDto(
            @JsonProperty("destination") String destination,
            @JsonProperty("endpoint") String topic,
            @JsonProperty("payload") List<String> messages) {
        this.destination = destination;
        this.topic = topic;
        this.messages = messages;
    }

    public String getDestination() {
        return destination;
    }

    @Override
    public String getTopic() {
        return topic;
    }

    @Override
    public List<ByteString> getMessages() {
        if (messages == null) {
            return null;
        }
        return messages.stream() // [ null, "{\"PageId\": 123, \"RtbBlocks\" : [...] }", null ]
                .filter(Objects::nonNull)
                .map(ByteString::copyFromUtf8)
                .toList();
    }

    @Override
    public String toString() {
        return "JsonLogbrokerDto{" +
                "destination='" + destination + '\'' +
                ", topic='" + topic + '\'' +
                ", messages=" + messages +
                '}';
    }
}
