package ru.yandex.partner.logbrokerapi.health;

import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthComponent;
import org.springframework.boot.actuate.health.HealthContributorRegistry;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.boot.actuate.health.HealthEndpointGroups;
import org.springframework.boot.actuate.health.Status;


public class CustomHealthEndpoint extends HealthEndpoint {

    public CustomHealthEndpoint(HealthContributorRegistry registry, HealthEndpointGroups groups) {
        super(registry, groups);
    }

    @Override
    public HealthComponent health() {
        HealthComponent healthComponent = super.health();
        if (healthComponent.getStatus() == Status.UP) {
            //  Урезаем details не нужны когда UP
            return Health.up().build();
        }
        return healthComponent;
    }

}
