package ru.yandex.partner.logbrokerapi.health;

import java.io.IOException;
import java.net.Socket;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.stereotype.Component;

import ru.yandex.partner.unifiedagent.UnifiedAgentProperties;

@Component("unifiedAgentHealthCheck")
public class UnifiedAgentHealthIndicator implements HealthIndicator {
    private final String host;
    private final int port;

    @Autowired
    public UnifiedAgentHealthIndicator(UnifiedAgentProperties unifiedAgentProperties) {
        this.host = unifiedAgentProperties.getHost();
        this.port = unifiedAgentProperties.getPort();
    }

    @Override
    public Health health() {
        try (Socket ignored = new Socket(host, port)) {
            return Health.up().build();
        } catch (IOException ex) {
            return Health
                    .down()
                    .withDetail("Unavailable: " + host + ":" + port + ". Details: " + ex.getMessage(), ex)
                    .build();
        }
    }
}
