#!/bin/bash

APP_ROOT=${1:-/app/java/mocks}

# Нужен для teamcity, так как teamcity себе ставит восьмую джаву
# (как зависимый покет от teamcity-agent->teamcity-common->yandex-jdk8)
# Не будем этому препятствовать, поставим рядом 17ю и будем на нее ссылаться при старте приложения
${JAVA_PROGRAM_PATH:-/usr/bin/java} -cp "$APP_ROOT/lib/*:" \
    -Djava.library.path="$APP_ROOT/lib/" \
    ru.yandex.partner.mocks.MockApp \
    --spring.profiles.active=mock \
    --server.port=${MOCK_SERVER_PORT} \
    --management.server.port=${MOCK_SERVER_MANAGEMENT_PORT} \
    --logging.level.root=INFO
