package ru.yandex.partner.mocks

import org.apache.commons.io.IOUtils
import org.springframework.http.HttpStatus
import org.springframework.web.bind.annotation.RestController
import org.springframework.web.bind.annotation.PostMapping
import javax.servlet.http.HttpServletRequest
import org.springframework.web.server.ResponseStatusException
import java.io.IOException

@RestController
class BalanceController {
    @PostMapping(value = ["/xmlrpc"], produces = ["*/*"], consumes = ["*/*"])
    @Throws(IOException::class)
    fun endpoint(request: HttpServletRequest): String {
        val body = IOUtils.toString(request.inputStream)
        return if (body.contains("Balance.GetPartnerContracts")) {
            IOUtils.toString(this.javaClass.getResourceAsStream("/Balance.GetPartnerContracts.xml"))
        } else if (body.contains("Balance2.GetBank")) {
            IOUtils.toString(this.javaClass.getResourceAsStream("/Balance2.GetBank.xml"))
        } else {
            throw ResponseStatusException(HttpStatus.NOT_IMPLEMENTED, "mock is not ready")
        }
    }
}
