package ru.yandex.partner.mocks

import org.apache.commons.io.IOUtils
import org.springframework.http.HttpStatus
import org.springframework.web.bind.annotation.RestController
import org.springframework.web.bind.annotation.GetMapping
import org.springframework.web.bind.annotation.RequestParam
import org.springframework.web.server.ResponseStatusException
import java.io.IOException

@RestController
class BlackboxController {
    @GetMapping(value = ["/blackbox"])
    @Throws(IOException::class)
    fun endpoint(@RequestParam method: String, @RequestParam uid: Long): String {
        if ("userinfo" != method) {
            throw ResponseStatusException(HttpStatus.NOT_IMPLEMENTED, "Method: $method")
        }
        return if (uid == 1015L) {
            IOUtils.toString(
                this.javaClass.getResourceAsStream("/Blackbox.1015.xml")
            )
        } else {
            IOUtils.toString(
                this.javaClass.getResourceAsStream("/Blackbox.UID.xml")
            ).replace("\$UID", java.lang.Long.toString(uid))
        }
    }
}
