package ru.yandex.partner.mocks

import org.apache.commons.io.IOUtils
import org.springframework.web.bind.annotation.RestController
import org.springframework.web.bind.annotation.GetMapping
import java.io.IOException
import javax.servlet.http.HttpServletRequest

@RestController
class YtController {
    @GetMapping(value = ["/hosts"])
    fun hosts(request: HttpServletRequest): String {
        return "[ \"" + request.getHeader("Host") + "\" ]"
    }

    @GetMapping(value = ["/api/v3/select_rows"])
    @Throws(IOException::class)
    fun endpoint(): String {
        return IOUtils.toString(
            this.javaClass.getResourceAsStream("/Tags.ytjson")
        )
    }
}
