#!/bin/bash -e

APP_ROOT=${1:-/app/java/runner}

/usr/bin/java -cp "$APP_ROOT/lib/*:" \
    -Djava.library.path="$APP_ROOT/lib/" \
    -Dspring.profiles.active=$RUNNER_PROFILE \
    -Dserver.port=${RUNNER_SERVER_PORT} \
    -Dmanagement.server.port=${RUNNER_MANAGEMENT_PORT:-9790} \
    -Dspring.pid.file=${RUNNER_PID_FILE:-runner.pid} \
    -Dlogging.filepath=${RUNNER_LOG_FILE:-./java-dev.log} \
    -Dlogging.level.root=${RUNNER_LOG_LEVEL:-INFO} \
    ${JAVA_OPTS} \
    -Xmx4g \
    ru.yandex.partner.runner.App \
    $@
