package ru.yandex.partner.runner.configutation;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.partner.core.configuration.CoreConfiguration;
import ru.yandex.partner.defaultconfiguration.DefaultPartnerConfiguration;
import ru.yandex.partner.defaultconfiguration.rpc.DefaultRpcConfig;
import ru.yandex.partner.libs.extservice.balance.BalanceService;
import ru.yandex.partner.libs.extservice.balance.BalanceXmlRpcConfig;
import ru.yandex.partner.libs.extservice.balance.SimpleBalanceService;
import ru.yandex.partner.libs.memcached.configuration.MemcachedConfiguration;

@Configuration
@Import({
        MemcachedConfiguration.class,
        CoreConfiguration.class,
        DefaultPartnerConfiguration.class
})
public class AppConfiguration {

    @Bean
    public BalanceXmlRpcConfig balanceXmlRpcConfig(DefaultRpcConfig defaultRpcConfig) {
        return new BalanceXmlRpcConfig(defaultRpcConfig);
    }

    @Bean
    public BalanceService balanceService(BalanceXmlRpcConfig rpcConfig) {
        return new SimpleBalanceService(rpcConfig);
    }
}


