package ru.yandex.partner.runner.service;

import java.util.List;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.service.adfox.AdfoxService;
import ru.yandex.partner.core.service.adfox.GraphqlResponse;

@Profile("test-adfox-graphql")
@Component
public class AdfoxGraphqlServiceTestRunner implements CommandLineRunner {

    private static final Logger LOGGER = LoggerFactory.getLogger(AdfoxGraphqlServiceTestRunner.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper()
            .enable(SerializationFeature.INDENT_OUTPUT);

    private final AdfoxService adfoxService;
    private final ApplicationContext applicationContext;

    @Autowired
    public AdfoxGraphqlServiceTestRunner(
            AdfoxService adfoxService,
            ApplicationContext applicationContext
    ) {
        this.adfoxService = adfoxService;
        this.applicationContext = applicationContext;
    }

    @Override
    public void run(String... args) {
        GraphqlResponse resp;
        try {
            if ("--deleteBlock".equals(args[0])) {
                Long placeId = Long.parseLong(args[1]);
                resp = adfoxService.deleteBlock(List.of(placeId)).get();
            } else if ("--updateBlockName".equals(args[0])) {
                Long placeId = Long.parseLong(args[1]);
                String newName = args[2];
                resp = adfoxService.updateBlockName(placeId, newName).get();
            } else {
                throw new IllegalArgumentException("--deleteBlock <placeId> OR --updateBlockName <placeId> <name>");
            }
            LOGGER.info(OBJECT_MAPPER.writeValueAsString(resp));
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        } finally {
            System.exit(SpringApplication.exit(applicationContext, () -> 0));
        }
    }
}
