package ru.yandex.partner.runner.service;

import java.io.IOException;
import java.util.Map;

import org.jetbrains.annotations.NotNull;
import org.jooq.DSLContext;
import org.json.JSONException;
import org.skyscreamer.jsonassert.JSONAssert;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

import ru.yandex.partner.libs.bs.json.BlockBkDataComparator;

import static ru.yandex.partner.dbschema.partner.tables.ContextOnSiteRtb.CONTEXT_ON_SITE_RTB;

@Profile("block-bk-data-serialization")
@Component
public class BlockBkDataSerializationCheckRunner extends BkDataCheckRunner<Void> {
    @Autowired
    private DSLContext dslContext;
    private BlockBkDataComparator comparator = new BlockBkDataComparator();

    @NotNull
    @Override
    protected Map<Long, String> fetchBkData(long start) {
        return dslContext.select(CONTEXT_ON_SITE_RTB.UNIQUE_ID, CONTEXT_ON_SITE_RTB.BK_DATA)
                .from(CONTEXT_ON_SITE_RTB)
                .where(CONTEXT_ON_SITE_RTB.UNIQUE_ID.greaterThan(start))
                .orderBy(CONTEXT_ON_SITE_RTB.UNIQUE_ID)
                .limit(chunkSize)
                .fetchMap(CONTEXT_ON_SITE_RTB.UNIQUE_ID, CONTEXT_ON_SITE_RTB.BK_DATA);
    }

    @Override
    protected void checkBkData(String bkData, Void container) throws IOException, JSONException {
        var dataAfterConvert = bkDataConverter.convertBlockBackAndForth(bkData);
        JSONAssert.assertEquals(bkData, dataAfterConvert, comparator);
    }
}
