package ru.yandex.partner.runner.service;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.bs.BkDataException;
import ru.yandex.partner.core.bs.enrich.BkDataService;

@Profile("test-send-to-bk")
@Component
public class SendToBkTestRunner implements CommandLineRunner {

    private static final Logger LOGGER = LoggerFactory.getLogger(SendToBkTestRunner.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper()
            .enable(SerializationFeature.INDENT_OUTPUT);

    private final ApplicationContext applicationContext;
    private final BkDataService bkDataService;

    @Autowired
    public SendToBkTestRunner(
            ApplicationContext applicationContext,
            BkDataService bkDataService) {
        this.applicationContext = applicationContext;
        this.bkDataService = bkDataService;
    }

    @Override
    public void run(String... args) {
        try {
            String bkdata;
            if ("-d".equals(args[0]) || "--data".equals(args[0])) {
                bkdata = args[1];
            } else if ("--file-name".equals(args[0])) {
                bkdata = Files.readString(Path.of(args[1]));
            } else {
                throw new IllegalArgumentException("-d <json page bkdata> is required");
            }
            var page = bkDataService.enrichPage(bkdata, true);
            bkDataService.send(page);
            LOGGER.info(OBJECT_MAPPER.writeValueAsString(bkDataService.convertToJson(page)));
        } catch (BkDataException | IOException e) {
            e.printStackTrace();
        } finally {
            System.exit(SpringApplication.exit(applicationContext, () -> 0));
        }
    }
}
