package ru.yandex.partner.runner.service;

import java.util.concurrent.TimeUnit;

import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.service.statevalidation.block.RtbBlockStateValidationService;

@Profile("vidationWithBenchmark")
@BenchmarkMode({Mode.All})
@Component
@State(Scope.Benchmark)
@OutputTimeUnit(TimeUnit.SECONDS)
public class ValidationBenchMarkRunner implements CommandLineRunner {
    private static RtbBlockStateValidationService blockStateValidationService;
    private static int step;

    @Autowired
    public void setBlockStateValidationService(RtbBlockStateValidationService blockStateValidationService) {
        ValidationBenchMarkRunner.blockStateValidationService = blockStateValidationService;
    }

    @Autowired
    public void setStep(@Value("${cron.validation.rtbBlock.step}") int step) {
        ValidationBenchMarkRunner.step = step;
    }

    @Override
    public void run(String... args) throws Exception {
        Options opts = new OptionsBuilder()
                .include("\\." + this.getClass().getSimpleName() + "\\.")
                .warmupIterations(1)
                .measurementIterations(2)
                .forks(0)
                .threads(1)
                .shouldDoGC(true)
                .shouldFailOnError(true)
                .jvmArgs("-server")
                .build();

        new Runner(opts).run();
    }


    @Benchmark
    public void benchmark() {
        blockStateValidationService.validateObjects(1, step * 5L);
    }

}

