package ru.yandex.partner.testapi;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.partner.testapi.service.PageIdGeneratorService;

@RestController
public class IntapiController {
    private final PageIdGeneratorService pageIdGeneratorService;

    @Autowired
    public IntapiController(PageIdGeneratorService pageIdGeneratorService) {
        this.pageIdGeneratorService = pageIdGeneratorService;
    }

    @PostMapping(path = {"intapi/get_next_page_id"})
    public Result nextPageId(@RequestParam String service) {
        return new Result(pageIdGeneratorService.nextPageId(service));
    }

    @GetMapping(path = "alive")
    public String alive() {
        return "{\"success\":true}";
    }

    private static class Result {
        @JsonProperty("page_id")
        private final Long pageId;

        Result(Long pageId) {
            this.pageId = pageId;
        }

        public Long getPageId() {
            return pageId;
        }
    }
}
