package ru.yandex.partner.testapi.configuration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.partner.defaultconfiguration.MysqlConfiguration;

@Configuration
@Import({MysqlConfiguration.class})
public class DbConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbConfiguration.class);

    @Bean
    @ConfigurationProperties("mysql.dictionary-tables")
    public List<String> dictionaryTablesConfiguration() {
        return new ArrayList<>();
    }

    @Bean
    public Set<String> dictionaryTables(List<String> dictionaryTablesConfiguration) {
        if (dictionaryTablesConfiguration.isEmpty()) {
            LOGGER.warn("DICTIONARY TABLES are not configured. It's may lead to errors");
            return Collections.emptySet();
        } else {
            Set<String> stringSet = Set.copyOf(dictionaryTablesConfiguration);
            if (stringSet.size() < dictionaryTablesConfiguration.size()) {
                LOGGER.warn("DICTIONARY TABLES have duplicates");
            }
            return stringSet;
        }
    }
}
