package ru.yandex.partner.testapi.configuration;

import java.util.List;
import java.util.Set;

import org.jooq.DSLContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.partner.libs.memcached.MemcachedService;
import ru.yandex.partner.testapi.fixture.Fixture;
import ru.yandex.partner.testapi.fixture.service.idprovider.IdProviderService;
import ru.yandex.partner.testapi.fixture.service.tus.TusService;
import ru.yandex.partner.testapi.jooq.LoggingExecuteListener;
import ru.yandex.partner.testapi.service.testcase.BaseTestApiService;
import ru.yandex.partner.testapi.service.testcase.ConcurrentTestApiService;
import ru.yandex.partner.testapi.service.testcase.TestApiService;

@Configuration
public class TestApiServiceConfiguration {

    @Bean
    public TestApiService testApiService(DSLContext dsl,
                                         LoggingExecuteListener loggingExecuteListener,
                                         List<Fixture> fixtures,
                                         TusService tusService,
                                         Set<String> dictionaryTables,
                                         IdProviderService idProviderService,
                                         MemcachedService memcachedService) {
        return new ConcurrentTestApiService(
                new BaseTestApiService(
                        dsl,
                        loggingExecuteListener,
                        fixtures,
                        tusService,
                        dictionaryTables,
                        idProviderService,
                        memcachedService
                )
        );
    }
}
