package ru.yandex.partner.testapi.configuration;

import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.http.MediaType;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import ru.yandex.partner.defaultconfiguration.GracefulShutdown;

/**
 * Класс для дополнительной настройки WebMVC
 */
@Configuration
@Import({GracefulShutdown.class})
@EnableWebMvc
public class WebConfig implements WebMvcConfigurer {

    /**
     * Настройка согласования типов возвращаемого контента:
     * - возвращаемый тип json
     *
     * @param configurer ContentNegotiationConfigurer
     */
    @Override
    public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
        configurer
                .mediaType("json", MediaType.APPLICATION_JSON)
                .ignoreAcceptHeader(true)
                .defaultContentType(MediaType.APPLICATION_JSON);
    }
}
