package ru.yandex.partner.testapi.fixture;

import java.util.Collections;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.annotation.JsonInclude;

public class FixtureResult {
    private final String pk;
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    private final Map<String, Object> params;

    public FixtureResult(String pk) {
        this(pk, Collections.emptyMap());
    }

    public FixtureResult(String pk, Map<String, Object> params) {
        this.pk = pk;
        this.params = params;
    }

    public Map<String, Object> getParams() {
        return params;
    }

    public String getPk() {
        return pk;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", FixtureResult.class.getSimpleName() + "[", "]")
                .add("pk='" + pk + "'")
                .add("params=" + params)
                .toString();
    }
}
