package ru.yandex.partner.testapi.fixture.block;

import java.util.List;

import org.jooq.DSLContext;

public abstract class AbstractMobileBlockFixture extends AbstractBlockFixture {

    private final BlockFixtureService blockFixtureService;

    public AbstractMobileBlockFixture(DSLContext dslContext, BlockFixtureService blockFixtureService) {
        super(dslContext);
        this.blockFixtureService = blockFixtureService;
    }

    @Override
    public String getPageIdFieldName() {
        return blockFixtureService.getPageIdFieldName();
    }

    @Override
    protected Long getNextBlockIdFromSeq(Long pageId) {
        return blockFixtureService.getNextBlockIdFromSeq(pageId);
    }

    @Override
    protected void updatePageBlocksCount(Long pageId) {
        blockFixtureService.updatePageBlocksCount(pageId);
    }

    @Override
    public String getPageFixtureName() {
        return blockFixtureService.getPageFixtureName();
    }

    @Override
    protected List<String> getMediaTypes() {
        return List.of(
                "300x250"
        );
    }
}
