package ru.yandex.partner.testapi.fixture.block.context;

import org.jooq.DSLContext;
import org.springframework.stereotype.Service;

import ru.yandex.partner.testapi.fixture.FixtureUtils;
import ru.yandex.partner.testapi.fixture.block.BlockFixtureService;

import static ru.yandex.partner.dbschema.partner.Tables.INTERNAL_CONTEXT_ON_SITE_BLOCK_SEQ;
import static ru.yandex.partner.dbschema.partner.Tables.INTERNAL_CONTEXT_ON_SITE_CAMPAIGN;


@Service
public class InternalContextBlockFixtureService implements BlockFixtureService {
    private final DSLContext dslContext;

    public InternalContextBlockFixtureService(DSLContext dslContext) {
        this.dslContext = dslContext;
    }

    @Override
    public String getPageFixtureName() {
        return "internal_context_page";
    }

    @Override
    public String getPageIdFieldName() {
        return "campaign_id";
    }

    @Override
    public Long getNextBlockIdFromSeq(Long pageId) {
        return FixtureUtils.getNextId(pageId, dslContext,
                INTERNAL_CONTEXT_ON_SITE_BLOCK_SEQ.CAMPAIGN_ID,
                INTERNAL_CONTEXT_ON_SITE_BLOCK_SEQ.NEXT_BLOCK_ID);
    }

    @Override
    public void updatePageBlocksCount(Long pageId) {
        dslContext.update(INTERNAL_CONTEXT_ON_SITE_CAMPAIGN)
                .set(INTERNAL_CONTEXT_ON_SITE_CAMPAIGN.BLOCKS_COUNT,
                        INTERNAL_CONTEXT_ON_SITE_CAMPAIGN.BLOCKS_COUNT.plus(1))
                .where(INTERNAL_CONTEXT_ON_SITE_CAMPAIGN.ID.eq(pageId))
                .execute();
    }
}
