package ru.yandex.partner.testapi.fixture.block.context;

import org.jooq.DSLContext;
import org.springframework.stereotype.Service;

import ru.yandex.partner.testapi.fixture.FixtureUtils;
import ru.yandex.partner.testapi.fixture.block.BlockFixtureService;

import static ru.yandex.partner.dbschema.partner.Tables.CONTEXT_ON_SITE_CAMPAIGN;
import static ru.yandex.partner.dbschema.partner.tables.ContextOnSiteBlockSeq.CONTEXT_ON_SITE_BLOCK_SEQ;

@Service
public class PartnerContextBlockFixtureService implements BlockFixtureService {
    private final DSLContext dslContext;

    public PartnerContextBlockFixtureService(DSLContext dslContext) {
        this.dslContext = dslContext;
    }

    @Override
    public String getPageFixtureName() {
        return "partner_context_page";
    }

    @Override
    public String getPageIdFieldName() {
        return "campaign_id";
    }

    @Override
    public Long getNextBlockIdFromSeq(Long pageId) {
        return FixtureUtils.getNextId(pageId, dslContext,
                CONTEXT_ON_SITE_BLOCK_SEQ.CAMPAIGN_ID,
                CONTEXT_ON_SITE_BLOCK_SEQ.NEXT_BLOCK_ID);
    }

    @Override
    public void updatePageBlocksCount(Long pageId) {
        dslContext.update(CONTEXT_ON_SITE_CAMPAIGN)
                .set(CONTEXT_ON_SITE_CAMPAIGN.BLOCKS_COUNT, CONTEXT_ON_SITE_CAMPAIGN.BLOCKS_COUNT.plus(1))
                .where(CONTEXT_ON_SITE_CAMPAIGN.ID.eq(pageId))
                .execute();
    }
}
