package ru.yandex.partner.testapi.fixture.block.context.content;

import java.time.LocalDateTime;
import java.util.Map;

import org.jooq.DSLContext;

import ru.yandex.partner.dbschema.partner.tables.records.FastBanRecord;
import ru.yandex.partner.testapi.fixture.FixtureResult;
import ru.yandex.partner.testapi.fixture.block.AbstractBlockFixture;
import ru.yandex.partner.testapi.fixture.block.BlockFixtureService;

import static ru.yandex.partner.dbschema.partner.Tables.FAST_BAN;

public abstract class AbstractContextContentBlockFixture extends AbstractBlockFixture {
    private final BlockFixtureService blockFixtureService;

    protected final LocalDateTime localDateTime = LocalDateTime.of(2018, 10, 4, 20, 37, 23);

    public AbstractContextContentBlockFixture(DSLContext dslContext,
                                              BlockFixtureService blockFixtureService) {
        super(dslContext);
        this.blockFixtureService = blockFixtureService;
    }

    @Override
    public String getPageFixtureName() {
        return blockFixtureService.getPageFixtureName();
    }

    @Override
    public String getPageIdFieldName() {
        return blockFixtureService.getPageIdFieldName();
    }

    @Override
    protected Long getNextBlockIdFromSeq(Long pageId) {
        return blockFixtureService.getNextBlockIdFromSeq(pageId);
    }

    @Override
    protected void updatePageBlocksCount(Long pageId) {
        blockFixtureService.updatePageBlocksCount(pageId);
    }

    @Override
    protected FixtureResult createAndSaveForPageIdAndBlockId(Long pageId, Long blockId, Map<String, Object> optsMap) {
        FixtureResult fixtureResult = super.createAndSaveForPageIdAndBlockId(pageId, blockId, optsMap);
        insertFastBan(pageId, blockId);
        return fixtureResult;
    }

    protected FastBanRecord getBaseFastBanRecord(Long pageId, Long blockId) {
        FastBanRecord record = new FastBanRecord();
        record.setPageId(pageId);
        record.setBlockId(blockId);
        record.setUrl("https://yandex.ru/");
        record.setUrlMd5Hex("30b7df27e9f842b33cf9e517c98a075e");
        record.setCreateDate(LocalDateTime.of(2018, 10, 11, 17, 8, 15));

        return record;
    }

    protected abstract FastBanRecord getFastBanRecord(Long pageId, Long blockId);

    private void insertFastBan(Long pageId, Long blockId) {
        FastBanRecord record = getFastBanRecord(pageId, blockId);

        getDslContext().insertInto(FAST_BAN)
                .set(record)
                .execute();
    }
}
