package ru.yandex.partner.testapi.fixture.block.context.content;

import java.util.Map;

import org.jooq.DSLContext;
import org.jooq.Record;
import org.jooq.Table;
import org.springframework.stereotype.Component;

import ru.yandex.partner.dbschema.partner.enums.InternalContextOnSiteContentSiteVersion;
import ru.yandex.partner.dbschema.partner.tables.records.FastBanRecord;
import ru.yandex.partner.dbschema.partner.tables.records.InternalContextOnSiteContentRecord;
import ru.yandex.partner.testapi.fixture.block.context.InternalContextBlockFixtureService;

import static ru.yandex.partner.dbschema.partner.Tables.INTERNAL_CONTEXT_ON_SITE_CONTENT;

@Component
public class InternalContextContentBlockFixture extends AbstractContextContentBlockFixture {
    public static final String FIXTURE_NAME = "internal_context_content_block";

    public InternalContextContentBlockFixture(DSLContext dslContext,
                                              InternalContextBlockFixtureService blockFixtureService) {
        super(dslContext, blockFixtureService);
    }

    @Override
    public String getPublicIDPrefix() {
        return "C-I";
    }

    @Override
    public String getFixtureName() {
        return FIXTURE_NAME;
    }

    @Override
    protected Table<? extends Record> getTable() {
        return INTERNAL_CONTEXT_ON_SITE_CONTENT;
    }

    @Override
    protected FastBanRecord getFastBanRecord(Long pageId, Long blockId) {
        FastBanRecord record = getBaseFastBanRecord(pageId, blockId);
        record.setModel("internal_context_on_site_content");

        return record;
    }

    @Override
    protected Record getBlockRecord(Long pageId, Long blockId, Map<String, Object> optsMap) {
        InternalContextOnSiteContentRecord record = new InternalContextOnSiteContentRecord();
        record.setCampaignId(pageId);
        record.setId(blockId);
        record.setCreateDate(localDateTime);
        record.setCaption("Mocked YAN Partner Internal Recommend Widget");
        record.setMultistate(2L); // working
        record.setOpts(readOptsFromResource());
        record.setIsCustomBkData(0L);
        record.setAdfoxBlock(0L);
        record.setSiteVersion(InternalContextOnSiteContentSiteVersion.general);
        return record;
    }
}
