package ru.yandex.partner.testapi.fixture.block.context.content;

import java.util.Map;

import org.jooq.DSLContext;
import org.jooq.Record;
import org.jooq.Table;

import ru.yandex.partner.dbschema.partner.enums.ContextOnSiteRtbModel;
import ru.yandex.partner.dbschema.partner.enums.ContextOnSiteRtbSiteVersion;
import ru.yandex.partner.dbschema.partner.tables.records.ContextOnSiteRtbRecord;
import ru.yandex.partner.dbschema.partner.tables.records.FastBanRecord;
import ru.yandex.partner.testapi.fixture.block.context.PartnerContextBlockFixtureService;

import static ru.yandex.partner.dbschema.partner.Tables.CONTEXT_ON_SITE_RTB;

public abstract class PartnerContextContentBlockFixture extends AbstractContextContentBlockFixture {

    public PartnerContextContentBlockFixture(DSLContext dslContext,
                                             PartnerContextBlockFixtureService blockFixtureService) {
        super(dslContext, blockFixtureService);
    }

    @Override
    public String getPublicIDPrefix() {
        return "C-A";
    }

    @Override
    protected Table<? extends Record> getTable() {
        return CONTEXT_ON_SITE_RTB;
    }

    @Override
    protected FastBanRecord getFastBanRecord(Long pageId, Long blockId) {
        FastBanRecord record = getBaseFastBanRecord(pageId, blockId);
        record.setModel("context_on_site_content");

        return record;
    }

    protected ContextOnSiteRtbRecord getDefaultRecord(Long pageId, Long blockId, Map<String, Object> optsMap) {
        ContextOnSiteRtbRecord record = new ContextOnSiteRtbRecord();
        record.setCampaignId(pageId);
        record.setId(blockId);
        record.setModel(ContextOnSiteRtbModel.context_on_site_content);
        record.setCreateDate(localDateTime);
        record.setMultistate(2L); // working
        record.setOpts(readOptsFromResource());
        record.setIsCustomBkData(0L);
        record.setAdfoxBlock(0L);
        record.setSiteVersion(ContextOnSiteRtbSiteVersion.general);
        return record;
    }

    @Override
    protected Record getBlockRecord(Long pageId, Long blockId, Map<String, Object> optsMap) {
        return getDefaultRecord(pageId, blockId, optsMap);
    }
}
