package ru.yandex.partner.testapi.fixture.block.context.content;

import java.util.Map;

import org.jooq.DSLContext;
import org.jooq.Record;
import org.springframework.stereotype.Component;

import ru.yandex.partner.dbschema.partner.tables.records.ContextOnSiteRtbRecord;
import ru.yandex.partner.testapi.fixture.block.context.PartnerContextBlockFixtureService;

@Component
public class PartnerContextContentCommonBlockFixture extends PartnerContextContentBlockFixture {
    public static final String FIXTURE_NAME = "partner_context_content_block";

    public PartnerContextContentCommonBlockFixture(DSLContext dslContext,
                                                   PartnerContextBlockFixtureService blockFixtureService) {
        super(dslContext, blockFixtureService);
    }


    @Override
    public String getFixtureName() {
        return FIXTURE_NAME;
    }

    @Override
    protected Record getBlockRecord(Long pageId, Long blockId, Map<String, Object> optsMap) {
        ContextOnSiteRtbRecord record = getDefaultRecord(pageId, blockId, optsMap);
        record.setCaption("Mocked YAN Partner Recommend Widget");
        return record;
    }
}
