package ru.yandex.partner.testapi.fixture.block.context.natural;

import java.time.LocalDateTime;

import org.jooq.DSLContext;

import ru.yandex.partner.testapi.fixture.block.AbstractBlockFixture;
import ru.yandex.partner.testapi.fixture.block.BlockFixtureService;

public abstract class AbstractContextNaturalBlockFixture extends AbstractBlockFixture {
    private final BlockFixtureService blockFixtureService;

    protected LocalDateTime localDateTime = LocalDateTime.of(2018, 10, 4, 20, 37, 23);

    public AbstractContextNaturalBlockFixture(DSLContext dslContext, BlockFixtureService blockFixtureService) {
        super(dslContext);
        this.blockFixtureService = blockFixtureService;
    }

    @Override
    public String getPageFixtureName() {
        return blockFixtureService.getPageFixtureName();
    }

    @Override
    public String getPageIdFieldName() {
        return blockFixtureService.getPageIdFieldName();
    }

    @Override
    protected Long getNextBlockIdFromSeq(Long pageId) {
        return blockFixtureService.getNextBlockIdFromSeq(pageId);
    }

    @Override
    protected void updatePageBlocksCount(Long pageId) {
        blockFixtureService.updatePageBlocksCount(pageId);
    }
}
