package ru.yandex.partner.testapi.fixture.block.context.natural;

import java.util.Map;

import org.jooq.DSLContext;
import org.jooq.Record;
import org.jooq.Table;
import org.springframework.stereotype.Component;

import ru.yandex.partner.dbschema.partner.enums.InternalContextOnSiteNaturalSiteVersion;
import ru.yandex.partner.dbschema.partner.tables.records.InternalContextOnSiteNaturalRecord;
import ru.yandex.partner.testapi.fixture.block.context.InternalContextBlockFixtureService;

import static ru.yandex.partner.dbschema.partner.Tables.INTERNAL_CONTEXT_ON_SITE_NATURAL;

@Component
public class InternalContextNaturalBlockFixture extends AbstractContextNaturalBlockFixture {
    public static final String FIXTURE_NAME = "internal_context_natural_block";

    public InternalContextNaturalBlockFixture(DSLContext dslContext,
                                              InternalContextBlockFixtureService blockFixtureService) {
        super(dslContext, blockFixtureService);
    }

    @Override
    public String getFixtureName() {
        return FIXTURE_NAME;
    }

    @Override
    public String getPublicIDPrefix() {
        return "N-I";
    }

    @Override
    protected Table<? extends Record> getTable() {
        return INTERNAL_CONTEXT_ON_SITE_NATURAL;
    }

    @Override
    protected Record getBlockRecord(Long pageId, Long blockId, Map<String, Object> optsMap) {
        InternalContextOnSiteNaturalRecord record = new InternalContextOnSiteNaturalRecord();

        record.setCampaignId(pageId);
        record.setId(blockId);
        record.setCreateDate(localDateTime);
        record.setCaption("Mocked YAN Partner Natural Block");
        record.setMultistate(18L);
        record.setOpts(readOptsFromResource());
        record.setIsCustomBkData(0L);
        record.setAdfoxBlock(0L);
        record.setSiteVersion(InternalContextOnSiteNaturalSiteVersion.general);
        return record;
    }
}
