package ru.yandex.partner.testapi.fixture.block.context.natural;

import java.util.Map;

import org.jooq.DSLContext;
import org.jooq.Record;
import org.jooq.Table;

import ru.yandex.partner.dbschema.partner.enums.ContextOnSiteNaturalSiteVersion;
import ru.yandex.partner.dbschema.partner.tables.records.ContextOnSiteNaturalRecord;
import ru.yandex.partner.testapi.fixture.block.context.PartnerContextBlockFixtureService;

import static ru.yandex.partner.dbschema.partner.Tables.CONTEXT_ON_SITE_NATURAL;

public abstract class PartnerContextNaturalBlockFixture extends AbstractContextNaturalBlockFixture {

    public PartnerContextNaturalBlockFixture(DSLContext dslContext,
                                             PartnerContextBlockFixtureService blockFixtureService) {
        super(dslContext, blockFixtureService);
    }

    @Override
    public String getPublicIDPrefix() {
        return "N-A";
    }


    @Override
    protected Table<? extends Record> getTable() {
        return CONTEXT_ON_SITE_NATURAL;
    }

    protected ContextOnSiteNaturalRecord getDefaultRecord(Long pageId, Long blockId, Map<String, Object> optsMap) {
        ContextOnSiteNaturalRecord record = new ContextOnSiteNaturalRecord();
        record.setCampaignId(pageId);
        record.setId(blockId);
        record.setCreateDate(localDateTime);
        record.setMultistate(2L);
        record.setOpts(readOptsFromResource());
        record.setIsCustomBkData(0L);
        record.setAdfoxBlock(0L);
        record.setSiteVersion(ContextOnSiteNaturalSiteVersion.general);
        return record;
    }

    @Override
    protected Record getBlockRecord(Long pageId, Long blockId, Map<String, Object> optsMap) {
        return getDefaultRecord(pageId, blockId, optsMap);
    }
}
