package ru.yandex.partner.testapi.fixture.block.context.natural;

import java.util.Map;

import org.jooq.DSLContext;
import org.jooq.Record;
import org.springframework.stereotype.Component;

import ru.yandex.partner.dbschema.partner.tables.records.ContextOnSiteNaturalRecord;
import ru.yandex.partner.testapi.fixture.block.context.PartnerContextBlockFixtureService;

@Component
public class PartnerContextNaturalCommonBlockFixture extends PartnerContextNaturalBlockFixture {
    public static final String FIXTURE_NAME = "partner_context_natural_block";

    public PartnerContextNaturalCommonBlockFixture(DSLContext dslContext,
                                                   PartnerContextBlockFixtureService blockFixtureService) {
        super(dslContext, blockFixtureService);
    }

    @Override
    public String getFixtureName() {
        return FIXTURE_NAME;
    }

    @Override
    protected Record getBlockRecord(Long pageId, Long blockId, Map<String, Object> optsMap) {
        ContextOnSiteNaturalRecord record = getDefaultRecord(pageId, blockId, optsMap);
        record.setCaption("Mocked YAN Partner Native Block");
        return record;
    }
}
