package ru.yandex.partner.testapi.fixture.block.context.rtb;

import java.time.LocalDateTime;
import java.util.List;

import org.jooq.DSLContext;

import ru.yandex.partner.testapi.fixture.block.AbstractBlockFixture;
import ru.yandex.partner.testapi.fixture.block.BlockFixtureService;

public abstract class AbstractContextRtbBlockFixture extends AbstractBlockFixture {
    private final BlockFixtureService blockFixtureService;

    protected final LocalDateTime localDateTime = LocalDateTime.of(2018, 10, 11, 17, 8, 15);

    public AbstractContextRtbBlockFixture(DSLContext dslContext,
                                          BlockFixtureService blockFixtureService) {
        super(dslContext);
        this.blockFixtureService = blockFixtureService;
    }

    @Override
    public String getPageIdFieldName() {
        return blockFixtureService.getPageIdFieldName();
    }

    @Override
    public String getPageFixtureName() {
        return blockFixtureService.getPageFixtureName();
    }

    @Override
    protected void updatePageBlocksCount(Long pageId) {
        blockFixtureService.updatePageBlocksCount(pageId);
    }

    @Override
    protected Long getNextBlockIdFromSeq(Long pageId) {
        return blockFixtureService.getNextBlockIdFromSeq(pageId);
    }

    @Override
    protected List<String> getMediaTypes() {
        return List.of(
                "1000x120", "160x600", "240x400", "240x600", "300x250", "300x300",
                "300x500", "300x600", "336x280", "728x90", "970x250", "970x90"
        );
    }

    @Override
    protected List<Long> getDspIds() {
        return List.of(
                2563070L,
                2563117L,
                2563219L,
                2563167L,
                2563178L,
                2563254L,
                2563269L,
                2563130L
        );
    }
}
