package ru.yandex.partner.testapi.fixture.block.context.rtb;

import java.util.Arrays;
import java.util.Map;

import one.util.streamex.StreamEx;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Table;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.block.BlockUniqueIdConverter;
import ru.yandex.partner.dbschema.partner.enums.ContextOnSiteRtbModel;
import ru.yandex.partner.dbschema.partner.tables.records.ContextOnSiteRtbRecord;
import ru.yandex.partner.testapi.fixture.block.context.InternalContextBlockFixtureService;

import static ru.yandex.partner.dbschema.partner.Tables.CONTEXT_ON_SITE_RTB;
import static ru.yandex.partner.dbschema.partner.enums.ContextOnSiteRtbSiteVersion.desktop;
import static ru.yandex.partner.libs.utils.JooqUtils.applyPatchToRecord;

@Component
public class InternalContextRtbBlockFixture extends AbstractContextRtbBlockFixture {
    public static final String FIXTURE_NAME = "internal_context_rtb_block";

    private final Map<String, Field<?>> fieldTypes;

    public InternalContextRtbBlockFixture(DSLContext dslContext,
                                          InternalContextBlockFixtureService blockFixtureService) {
        super(dslContext, blockFixtureService);
        this.fieldTypes = StreamEx.of(Arrays.stream(new ContextOnSiteRtbRecord().fields()))
                .toMap(Field::getName, f -> f);
    }

    @Override
    public String getFixtureName() {
        return FIXTURE_NAME;
    }

    @Override
    public String getPublicIDPrefix() {
        return "R-I";
    }

    @Override
    protected Table<? extends Record> getTable() {
        return CONTEXT_ON_SITE_RTB;
    }

    @Override
    protected Record getBlockRecord(Long pageId, Long blockId, Map<String, Object> optsMap) {
        ContextOnSiteRtbRecord record = new ContextOnSiteRtbRecord();

        record.setModel(ContextOnSiteRtbModel.internal_context_on_site_rtb);
        record.setCampaignId(pageId);
        record.setId(blockId);
        record.setCreateDate(localDateTime);
        record.setUniqueId(BlockUniqueIdConverter.convertToUniqueId(
                BlockUniqueIdConverter.Prefixes.INTERNAL_CONTEXT_ON_SITE_RTB_PREFIX.getPrefixNumber(), pageId,
                blockId));
        record.setCaption("Mocked Internal Context RTB Block");
        record.setMultistate(2L);
        record.setGeo("[]");
        record.setMincpm(null);
        record.setComment("");
        record.setIsCustomBkData(0L);
//        record.setBkData();
//        record.setMediaActive();
//        record.setMediaBlocked();
//        record.setMediaCpm();
//        record.setTextActive();
//        record.setTextBlocked();
//        record.setTextCpm();
        record.setOpts(readOptsFromResource());
        record.setHorizontalAlign(1L);
        record.setAlternativeCode("");
        record.setBlind(0L);
        record.setStrategy(1L);
        record.setActive(1L);
        record.setExDirect(0L);
        record.setDuplicateDirect(0L);
        record.setShowVideo(1L);
        record.setSiteVersion(desktop);
        record.setAdfoxBlock(0L);

        applyPatchToRecord(record, fieldTypes, optsMap);
        return record;
    }
}
