package ru.yandex.partner.testapi.fixture.block.designtemplates;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;

import ru.yandex.partner.dbschema.partner.enums.DesignTemplatesType;
import ru.yandex.partner.dbschema.partner.tables.records.DesignTemplatesRecord;
import ru.yandex.partner.testapi.utils.ResourceUtils;


@ParametersAreNonnullByDefault
public abstract class AbstractAllDesignTemplatesFixture extends AbstractDesignTemplatesFixture {

    public AbstractAllDesignTemplatesFixture(DSLContext dslContext) {
        super(dslContext);
    }

    @Override
    protected List<DesignTemplatesRecord> getRecords(Long pageId, Long blockId) {
        var tgaRecord = new DesignTemplatesRecord();
        fillCommonData(tgaRecord, pageId, blockId);
        tgaRecord.setCaption("Исходный дизайн");
        tgaRecord.setType(DesignTemplatesType.tga);
        tgaRecord.setOpts(getResourceFor(DesignTemplatesType.tga));

        var mediaRecord = new DesignTemplatesRecord();
        fillCommonData(mediaRecord, pageId, blockId);
        mediaRecord.setCaption("General media design");
        mediaRecord.setType(DesignTemplatesType.media);
        mediaRecord.setOpts(getResourceFor(DesignTemplatesType.media));

        var videoRecord = new DesignTemplatesRecord();
        fillCommonData(videoRecord, pageId, blockId);
        videoRecord.setCaption("Видео дизайн");
        videoRecord.setType(DesignTemplatesType.video);
        videoRecord.setOpts(getResourceFor(DesignTemplatesType.video));

        var nativeRecord = new DesignTemplatesRecord();
        fillCommonData(nativeRecord, pageId, blockId);
        nativeRecord.setCaption("Нативный дизайн");
        nativeRecord.setType(DesignTemplatesType.native_);
        nativeRecord.setOpts(getResourceFor(DesignTemplatesType.native_));

        return List.of(tgaRecord, mediaRecord, videoRecord, nativeRecord);
    }

    private String getResourceFor(DesignTemplatesType designTemplatesType) {
        return ResourceUtils.readAsString(String.format("/data/fixtures/%s/%s.json",
                PartnerAllDesignTemplatesFixture.FIXTURE_NAME,
                designTemplatesType.getLiteral()));
    }
}
