package ru.yandex.partner.testapi.fixture.block.designtemplates;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;

import ru.yandex.partner.dbschema.partner.enums.DesignTemplatesType;
import ru.yandex.partner.dbschema.partner.tables.records.DesignTemplatesRecord;

@ParametersAreNonnullByDefault
public abstract class AbstractDefaultDesignTemplatesFixture extends AbstractDesignTemplatesFixture {

    protected AbstractDefaultDesignTemplatesFixture(DSLContext dslContext) {
        super(dslContext);
    }

    @Override
    protected List<DesignTemplatesRecord> getRecords(Long pageId, Long blockId) {
        DesignTemplatesRecord record = new DesignTemplatesRecord();
        fillCommonData(record, pageId, blockId);
        record.setCaption("design template 240x400");
        record.setOpts("{\"filter_tags\": [\"adaptive\", \"vertical\"], \"design_settings\": {\"name\": \"vertical\"," +
                " \"limit\": 1}, \"is_custom_format_direct\": 0}");
        record.setMultistate(0L);
        record.setType(DesignTemplatesType.tga);

        return List.of(record);
    }
}
