package ru.yandex.partner.testapi.fixture.block.designtemplates;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.databind.JsonNode;
import org.jooq.DSLContext;

import ru.yandex.partner.dbschema.partner.tables.records.DesignTemplatesRecord;
import ru.yandex.partner.libs.utils.JooqUtils;
import ru.yandex.partner.testapi.fixture.Fixture;
import ru.yandex.partner.testapi.fixture.FixtureContext;
import ru.yandex.partner.testapi.fixture.FixtureResult;

import static ru.yandex.partner.dbschema.partner.Tables.DESIGN_TEMPLATES;

@ParametersAreNonnullByDefault
public abstract class AbstractDesignTemplatesFixture implements Fixture {
    private final DSLContext dslContext;

    protected AbstractDesignTemplatesFixture(DSLContext dslContext) {
        this.dslContext = dslContext;
    }

    protected abstract String getRtbBlockFixtureName();

    @Override
    public final List<FixtureResult> createAndSave(JsonNode optsJson, FixtureContext fixtureContext) {
        List<FixtureResult> rtbBlockFixtureResults =
                fixtureContext.valueByFixtureName(getRtbBlockFixtureName());
        if (rtbBlockFixtureResults == null || rtbBlockFixtureResults.isEmpty()) {
            throw new RuntimeException("RtbBlock fixture fail");
        }
        List<FixtureResult> resultList = new ArrayList<>();
        for (var blockResults : rtbBlockFixtureResults) {
            var blockParams = blockResults.getParams();
            var pageId = (Long) blockParams.get("campaign_id");
            var blockId = (Long) blockParams.get("id");
            var templates = getRecords(pageId, blockId);
            var records =
                    JooqUtils.insertRecordsWithReturning(dslContext, DESIGN_TEMPLATES, templates, DESIGN_TEMPLATES.ID);
            resultList.add(
                    new FixtureResult(
                            pageId + " " + blockId,
                            Map.of("ids",
                                    records.stream().map(DesignTemplatesRecord::getId).toList())
                    )
            );
        }
        return resultList;
    }

    protected abstract List<DesignTemplatesRecord> getRecords(Long pageId, Long blockId);

    protected void fillCommonData(DesignTemplatesRecord record, Long pageId, Long blockId) {
        record.setPageId(pageId);
        record.setBlockId(blockId);
        record.setMultistate(0L);
        record.setUpdateTime(LocalDateTime.of(2018, 10, 11, 17, 8, 15));
    }

}
