package ru.yandex.partner.testapi.fixture.block.designtemplates;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.testapi.fixture.block.context.rtb.PartnerContextRtbBlockFixture;

@ParametersAreNonnullByDefault
@Component
public final class PartnerAllDesignTemplatesFixture extends AbstractAllDesignTemplatesFixture {
    public static final String FIXTURE_NAME = "partner_design_templates";

    @Autowired
    public PartnerAllDesignTemplatesFixture(DSLContext dslContext) {
        super(dslContext);
    }

    @Override
    protected String getRtbBlockFixtureName() {
        return PartnerContextRtbBlockFixture.FIXTURE_NAME;
    }

    @Override
    public List<String> getFixtureDepends() {
        return List.of(PartnerContextRtbBlockFixture.FIXTURE_NAME);
    }

    @Override
    public String getFixtureName() {
        return FIXTURE_NAME;
    }
}
