package ru.yandex.partner.testapi.fixture.block.designtemplates;

import java.util.List;

import org.jooq.DSLContext;
import org.springframework.stereotype.Component;

import ru.yandex.partner.dbschema.partner.enums.DesignTemplatesType;
import ru.yandex.partner.dbschema.partner.tables.records.DesignTemplatesRecord;
import ru.yandex.partner.testapi.fixture.block.context.rtb.PartnerContextRtbBlockFixture;
import ru.yandex.partner.testapi.utils.ResourceUtils;

@Component
public class PartnerSliderDesignTemplatesFixture extends AbstractDesignTemplatesFixture {
    public static final String FIXTURE_NAME = "partner_slider_design_templates";

    protected PartnerSliderDesignTemplatesFixture(DSLContext dslContext) {
        super(dslContext);
    }

    @Override
    public String getFixtureName() {
        return FIXTURE_NAME;
    }

    @Override
    public List<String> getFixtureDepends() {
        return List.of(PartnerContextRtbBlockFixture.FIXTURE_NAME);
    }

    @Override
    protected String getRtbBlockFixtureName() {
        return PartnerContextRtbBlockFixture.FIXTURE_NAME;
    }

    @Override
    protected List<DesignTemplatesRecord> getRecords(Long pageId, Long blockId) {
        var tgaRecord = new DesignTemplatesRecord();
        fillCommonData(tgaRecord, pageId, blockId);
        tgaRecord.setCaption("Исходный дизайн");
        tgaRecord.setType(DesignTemplatesType.tga);
        tgaRecord.setOpts(getResourceFor(DesignTemplatesType.tga));

        var mediaRecord = new DesignTemplatesRecord();
        fillCommonData(mediaRecord, pageId, blockId);
        mediaRecord.setCaption("Медиа дизайн");
        mediaRecord.setType(DesignTemplatesType.media);
        mediaRecord.setOpts(getResourceFor(DesignTemplatesType.media));

        var nativeRecord = new DesignTemplatesRecord();
        fillCommonData(nativeRecord, pageId, blockId);
        nativeRecord.setCaption("Нативный дизайн");
        nativeRecord.setType(DesignTemplatesType.native_);
        nativeRecord.setOpts(getResourceFor(DesignTemplatesType.native_));

        return List.of(tgaRecord, mediaRecord, nativeRecord);
    }

    private String getResourceFor(DesignTemplatesType designTemplatesType) {
        return ResourceUtils.readAsString(String.format("/data/fixtures/%s/%s.json",
                FIXTURE_NAME,
                designTemplatesType.getLiteral()));
    }
}
