package ru.yandex.partner.testapi.fixture.block.mobile;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.databind.JsonNode;
import org.jooq.DSLContext;
import org.jooq.Record;
import org.jooq.Table;
import org.slf4j.LoggerFactory;

import ru.yandex.partner.core.block.BlockUniqueIdConverter;
import ru.yandex.partner.dbschema.partner.enums.ContextOnSiteRtbModel;
import ru.yandex.partner.dbschema.partner.tables.records.ContextOnSiteRtbRecord;
import ru.yandex.partner.libs.utils.JooqUtils;
import ru.yandex.partner.testapi.fixture.FixtureContext;
import ru.yandex.partner.testapi.fixture.FixtureResult;
import ru.yandex.partner.testapi.fixture.FixtureUtils;
import ru.yandex.partner.testapi.fixture.block.AbstractMobileBlockFixture;
import ru.yandex.partner.testapi.fixture.block.BlockFixtureService;

import static ru.yandex.partner.dbschema.partner.Tables.CONTEXT_ON_SITE_RTB;


public abstract class InternalMobileBlockFixture extends AbstractMobileBlockFixture {
    public InternalMobileBlockFixture(DSLContext dslContext, BlockFixtureService blockFixtureService) {
        super(dslContext, blockFixtureService);
    }

    @Override
    public String getPublicIDPrefix() {
        return "R-IM";
    }

    @Override
    protected Table<? extends Record> getTable() {
        return CONTEXT_ON_SITE_RTB;
    }

    protected abstract void setDefaultsMobileRtb(ContextOnSiteRtbRecord record);

    @Override
    protected Record getBlockRecord(Long pageId, Long blockId, Map<String, Object> optsMap) {
        LocalDateTime localDateTime = LocalDateTime.of(2018, 10, 4, 20, 37, 23);

        ContextOnSiteRtbRecord record = new ContextOnSiteRtbRecord();
        record.setModel(ContextOnSiteRtbModel.internal_mobile_app_rtb);
        record.setCampaignId(pageId);
        record.setId(blockId);
        record.setCreateDate(localDateTime);
        record.setOpts(readOptsFromResource());
        record.setUniqueId(
                BlockUniqueIdConverter.convertToUniqueId(
                        BlockUniqueIdConverter.Prefixes.INTERNAL_MOBILE_RTB_PREFIX.getPrefixNumber(), pageId, blockId));

        MobileBlockFixtureUtils.setDefaultsMobileBlock(record);
        setDefaultsMobileRtb(record);

        JooqUtils.applyPatchToRecord(record, optsMap);

        return record;
    }

    @Override
    public List<FixtureResult> createAndSave(JsonNode optsJson, FixtureContext fixtureContext) {
        List<Map<String, Object>> optsList = FixtureUtils.extractRecordPatches(optsJson);


        List<FixtureResult> resultList = new ArrayList<>();
        for (Map<String, Object> params : optsList) {
            Long pageId = params.containsKey("campaign_id") ? (Long) params.get("campaign_id")
                    : getPageId(fixtureContext);
            Long blockId = params.containsKey("id") ? (Long) params.get("id")
                    : getNextBlockIdFromSeq(pageId);
            LoggerFactory.getLogger(InternalMobileBlockFixture.class).info(optsList.toString());
            resultList.add(createAndSaveForPageIdAndBlockId(pageId, blockId, params));
        }
        return resultList;
    }
}
