package ru.yandex.partner.testapi.fixture.block.mobile;

import org.jooq.DSLContext;
import org.springframework.stereotype.Service;

import ru.yandex.partner.testapi.fixture.FixtureUtils;
import ru.yandex.partner.testapi.fixture.block.BlockFixtureService;

import static ru.yandex.partner.dbschema.partner.Tables.INTERNAL_MOBILE_APP;
import static ru.yandex.partner.dbschema.partner.Tables.INTERNAL_MOBILE_APP_BLOCK_SEQ;

@Service
public class InternalMobileBlockFixtureService implements BlockFixtureService {
    private final DSLContext dslContext;

    public InternalMobileBlockFixtureService(DSLContext dslContext) {
        this.dslContext = dslContext;
    }

    @Override
    public String getPageFixtureName() {
        return "internal_mobile_page";
    }

    @Override
    public String getPageIdFieldName() {
        return "campaign_id";
    }

    @Override
    public Long getNextBlockIdFromSeq(Long pageId) {
        return FixtureUtils.getNextId(pageId, dslContext,
                INTERNAL_MOBILE_APP_BLOCK_SEQ.APPLICATION_ID,
                INTERNAL_MOBILE_APP_BLOCK_SEQ.NEXT_BLOCK_ID);
    }

    @Override
    public void updatePageBlocksCount(Long pageId) {
        dslContext.update(INTERNAL_MOBILE_APP)
                .set(INTERNAL_MOBILE_APP.BLOCKS_COUNT, INTERNAL_MOBILE_APP.BLOCKS_COUNT.plus(1))
                .where(INTERNAL_MOBILE_APP.ID.eq(pageId))
                .execute();
    }
}
