package ru.yandex.partner.testapi.fixture.block.mobile;

import org.jooq.DSLContext;
import org.springframework.stereotype.Component;

import ru.yandex.partner.dbschema.partner.tables.records.ContextOnSiteRtbRecord;

@Component
public class InternalMobileInterstitialBlockFixture extends InternalMobileBlockFixture {
    public static final String FIXTURE_NAME = "internal_mobile_interstitial_block";

    public InternalMobileInterstitialBlockFixture(
            DSLContext dslContext,
            InternalMobileBlockFixtureService blockFixtureService
    ) {
        super(dslContext, blockFixtureService);
    }

    @Override
    protected void setDefaultsMobileRtb(ContextOnSiteRtbRecord record) {
        MobileBlockFixtureUtils.setDefaultsInterstitialMobileRtb(
                record,
                "Mocked internal YAN Partner Interstitial Mobile RTB Block"
        );
    }

    @Override
    public String getFixtureName() {
        return FIXTURE_NAME;
    }
}
