package ru.yandex.partner.testapi.fixture.block.mobile;

import org.jooq.DSLContext;
import org.springframework.stereotype.Component;

import ru.yandex.partner.dbschema.partner.tables.records.ContextOnSiteRtbRecord;

@Component
public class InternalMobileNativeBlockFixture extends InternalMobileBlockFixture {
    public static final String FIXTURE_NAME = "internal_mobile_native_block";

    public InternalMobileNativeBlockFixture(
            DSLContext dslContext,
            InternalMobileBlockFixtureService blockFixtureService
    ) {
        super(dslContext, blockFixtureService);
    }

    @Override
    protected void setDefaultsMobileRtb(ContextOnSiteRtbRecord record) {
        MobileBlockFixtureUtils.setDefaultsNativeMobileRtb(
                record,
                "Mocked internal YAN Partner Native Mobile RTB Block"
        );
    }

    @Override
    public String getFixtureName() {
        return FIXTURE_NAME;
    }
}
