package ru.yandex.partner.testapi.fixture.block.mobile;

import org.jooq.DSLContext;
import org.jooq.Record;
import org.jooq.Table;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.dbschema.partner.tables.records.ContextOnSiteRtbRecord;

import static ru.yandex.partner.dbschema.partner.tables.ContextOnSiteRtb.CONTEXT_ON_SITE_RTB;

@Component
public class MobileBannerBlockFixture extends PartnerMobileBlockFixture {
    public static final String FIXTURE_NAME = "partner_mobile_banner_block";
    public static final String PAGE_FIXTURE_NAME = "partner_mobile_page";

    @Autowired
    public MobileBannerBlockFixture(
            DSLContext dslContext,
            PartnerMobileBlockFixtureService blockFixtureService
    ) {
        super(dslContext, blockFixtureService);
    }

    @Override
    protected Table<? extends Record> getTable() {
        return CONTEXT_ON_SITE_RTB;
    }

    @Override
    public String getPageFixtureName() {
        return PAGE_FIXTURE_NAME;
    }

    @Override
    public String getFixtureName() {
        return FIXTURE_NAME;
    }

    @Override
    protected void setDefaultsMobileRtb(ContextOnSiteRtbRecord record) {
        MobileBlockFixtureUtils.setDefaultsBannerMobileRtb(
                record,
                "Mocked YAN Partner Banner Mobile RTB Block"
        );
    }
}
