package ru.yandex.partner.testapi.fixture.block.mobile;

import ru.yandex.partner.dbschema.partner.tables.records.ContextOnSiteRtbRecord;

public class MobileBlockFixtureUtils {
    private MobileBlockFixtureUtils() {
    }

    public static void setDefaultsMobileBlock(ContextOnSiteRtbRecord record) {
        record.setMultistate(2L); // working
        record.setIsCustomBkData(0L);
        record.setAdfoxBlock(0L);
        record.setAlternativeCode("");
        record.setGeo("[]");
        record.setStrategy(1L);
        record.setShowVideo(0L);
    }

    public static void setDefaultsNativeMobileRtb(ContextOnSiteRtbRecord record, String caption) {
        record.setHorizontalAlign(null);
        record.setBlockType(MobileBlockTypes.NATIVE.getLiteral());
        record.setCaption(caption);
        record.setDirectBlock("native");
        record.setMediaBlock("native");
    }

    public static void setDefaultsBannerMobileRtb(ContextOnSiteRtbRecord record, String caption) {
        record.setBlockType(MobileBlockTypes.BANNER.getLiteral());
        record.setCaption(caption);
        record.setDirectBlock("300x250");
        record.setMediaBlock("300x250");
    }

    public static void setDefaultsInterstitialMobileRtb(ContextOnSiteRtbRecord record, String caption) {
        record.setBlockType(MobileBlockTypes.INTERSTITIAL.getLiteral());
        record.setCaption(caption);
        record.setDirectBlock("240x400");
        record.setMediaBlock("240x400");
    }

    public static void setDefaultsRewardedMobileRtb(ContextOnSiteRtbRecord record, String caption) {
        record.setBlockType(MobileBlockTypes.REWARDED.getLiteral());
        record.setCaption(caption);
        record.setDirectBlock("320x480");
        record.setMediaBlock("320x480");
    }
}
