package ru.yandex.partner.testapi.fixture.block.mobile;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.dbschema.partner.tables.records.ContextOnSiteRtbRecord;

@Component
public class MobileNativeBlockFixture extends PartnerMobileBlockFixture {
    public static final String FIXTURE_NAME = "partner_mobile_native_block";
    public static final String PAGE_FIXTURE_NAME = "partner_mobile_page";

    @Autowired
    public MobileNativeBlockFixture(
            DSLContext dslContext,
            PartnerMobileBlockFixtureService blockFixtureService
    ) {
        super(dslContext, blockFixtureService);
    }

    @Override
    public String getPageFixtureName() {
        return PAGE_FIXTURE_NAME;
    }

    @Override
    public String getFixtureName() {
        return FIXTURE_NAME;
    }

    @Override
    protected void setDefaultsMobileRtb(ContextOnSiteRtbRecord record) {
        MobileBlockFixtureUtils.setDefaultsNativeMobileRtb(
                record,
                "Mocked YAN Partner Native Mobile RTB Block"
        );
    }
}
